import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const images = [
    '/images/slider-1.jpg',
    '/images/slider-2.jpg',
    '/images/slider-3.jpg',
    '/images/slider-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-film">
      <div className="slider-wrapper-film">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentIndex}
            className="slide-film"
            initial={{ opacity: 0, x: 100, scale: 1.1 }}
            animate={{ opacity: 1, x: 0, scale: 1 }}
            exit={{ opacity: 0, x: -100, scale: 0.9 }}
            transition={{ duration: 0.6 }}
            style={{
              backgroundImage: `url(${images[currentIndex]})`
            }}
          >
            <div className="slide-overlay-film"></div>
            <div className="slide-frame-film"></div>
          </motion.div>
        </AnimatePresence>

        <button className="slider-btn-film slider-btn-prev-film" onClick={goToPrevious}>
          <ChevronLeft size={28} strokeWidth={2.5} />
        </button>
        <button className="slider-btn-film slider-btn-next-film" onClick={goToNext}>
          <ChevronRight size={28} strokeWidth={2.5} />
        </button>

        <div className="slider-dots-film">
          {images.map((_, index) => (
            <button
              key={index}
              className={`dot-film ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

